/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateInfoModel;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpdateWizardModel
extends WizardModel {
    protected List fInstalledFiles;
    public static final String CATALOG_FILE_NAME = "/catalog.dat";
    protected String catalogFile;
    protected Vector availableModules;
    protected Vector selectedModules;
    protected String proxyHost;
    protected String proxyPort;
    protected boolean useProxy;
    protected String URL;
    public boolean finishable = false;
    protected Vector selectedUpdateFiles;
    protected int fUpdateMode;
    public static final String RENAME_PREFIX = "update_";

    public UpdateWizardModel() {
        this.title = "Update";
        this.panelModels = new WizardPanelModel[20];
        this.panelModels[0] = new UpdateInfoModel(this);
    }

    public void setStartPanelModel(WizardPanelModel wizardPanelModel) {
        this.panelModels[0] = wizardPanelModel;
    }

    public boolean canCancel() {
        return !this.canFinish();
    }

    public boolean canFinish() {
        return this.finishable;
    }

    public void addInstalledFile(File installedFile) {
        List installedFiles = this.getInstalledFiles();
        if (!installedFiles.contains(installedFile)) {
            installedFiles.add(installedFile);
        }
    }

    public List getInstalledFiles() {
        if (this.fInstalledFiles == null) {
            this.fInstalledFiles = new ArrayList();
        }
        return this.fInstalledFiles;
    }

    public boolean canPrevious() {
        if (this.canFinish()) {
            return false;
        }
        return super.canPrevious();
    }

    public Object finish() {
        super.finish();
        Application application = Application.getInstance();
        application.setUpdateWizardModel(this);
        application.exit(true);
        return Boolean.TRUE;
    }

    public Vector getAvailableModules() {
        return this.availableModules;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public Vector getSelectedModules() {
        return this.selectedModules;
    }

    public Vector getSelectedUpdateFiles() {
        return this.selectedUpdateFiles;
    }

    public int getUpdateMode() {
        return this.fUpdateMode;
    }

    public String getURL() {
        return this.URL;
    }

    public boolean isFinishable() {
        return this.finishable;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void parseCatalogFile() throws Exception {
        this.availableModules = new Vector();
        StringTokenizer lineFeedTokenizer = new StringTokenizer(this.catalogFile, "\n");
        Version currentProgramVersion = Version.getCurrentVersion();
        while (lineFeedTokenizer.hasMoreTokens()) {
            String lineString = lineFeedTokenizer.nextToken();
            if (lineString.startsWith("#")) continue;
            ModuleInfo moduleInfo = new ModuleInfo(lineString);
            if (moduleInfo.validFromVersion.compareTo(currentProgramVersion) >= 1 || moduleInfo.validToVersion.compareTo(currentProgramVersion) <= -1 || !moduleInfo.applicableToVersion(currentProgramVersion) || moduleInfo.processorArchitecture.compareTo(System.getProperty("sun.arch.data.model")) != 0 && moduleInfo.processorArchitecture.compareTo("all") != 0) continue;
            this.availableModules.add(moduleInfo);
        }
    }

    public WizardPanelModel previous() {
        this.finishable = false;
        return super.previous();
    }

    public void setAvailableModules(Vector newAvailableModules) {
        this.availableModules = newAvailableModules;
    }

    public void setCatalogFile(String catalog) {
        this.catalogFile = catalog;
    }

    public void setFinishable(boolean newFinishable) {
        this.finishable = newFinishable;
    }

    public void setProxyHost(String newProxyHost) {
        this.proxyHost = newProxyHost;
    }

    public void setProxyPort(String newProxyPort) {
        this.proxyPort = newProxyPort;
    }

    public void setSelectedModules(Vector newSelectedModules) {
        this.selectedModules = newSelectedModules;
    }

    public void setSelectedUpdateFiles(Vector newSelectedUpdateFiles) {
        this.selectedUpdateFiles = newSelectedUpdateFiles;
    }

    public void setUpdateMode(int newUpdateMode) {
        this.fUpdateMode = newUpdateMode;
    }

    public void setURL(String newURL) {
        this.URL = newURL;
    }

    public void setUseProxy(boolean newUseProxy) {
        this.useProxy = newUseProxy;
    }

    protected void renameUpdateFiles() {
        Iterator installedFiles = this.getInstalledFiles().iterator();
        boolean success = false;
        while (installedFiles.hasNext()) {
            File installedFile = (File)installedFiles.next();
            if (!installedFile.getName().toLowerCase().startsWith(RENAME_PREFIX.toLowerCase())) continue;
            String actualFileName = installedFile.getName().substring(RENAME_PREFIX.length());
            String backupFileName = actualFileName + ".bak";
            File actualFile = new File(installedFile.getParentFile(), actualFileName);
            File backupFile = new File(installedFile.getParentFile(), backupFileName);
            int i = 0;
            while (backupFile.exists()) {
                backupFile = new File(installedFile.getParentFile(), backupFileName + String.valueOf(++i));
            }
            System.out.print("backupFileName: " + backupFile.getPath());
            try {
                System.out.print("copying " + actualFile.getPath() + " to " + backupFile.getPath() + "...");
                Util.copyFile(actualFile, backupFile);
                System.out.println("ok");
                System.out.print("copying " + installedFile.getPath() + " to " + actualFile.getPath() + "...");
                Util.copyFile(installedFile, actualFile);
                System.out.println("ok");
                System.out.print("deleting " + installedFile.getPath() + "...");
                success = installedFile.delete();
                System.out.println(success);
            }
            catch (IOException ioe) {
                System.out.println("Exeption while renaming update-files in finishing update:");
                ioe.printStackTrace();
            }
        }
    }

    public void finishUpdate() {
        this.renameUpdateFiles();
    }
}

